package com.agilex.healthcare.directscheduling.dataservice;

public enum CancelCodes {
    NO_SHOW("NO-SHOW"),
    CANCELLED_BY_CLINIC("CANCELLED BY CLINIC"),
    NO_SHOW_AND_AUTO_RE_BOOK("NO-SHOW & AUTO RE-BOOK"),
    CANCELLED_BY_CLINIC_AND_AUTO_RE_BOOK("CANCELLED BY CLINIC & AUTO RE-BOOK"),
    INPATIENT_APPOINTMENT("INPATIENT APPOINTMENT"),
    CANCELLED_BY_PATIENT("CANCELLED BY PATIENT"),
    CANCLEED_BY_PATIENT_AND_AUTO_RE_BOOK("CANCELLED BY PATIENT & AUTO-REBOOK"),
    NO_ACTION_TAKEN("NO ACTION TAKEN"),
    INPATIENT_NO_ACT_TAKN("INPATIENT/NO ACT TAKN");


    private String name;

    private CancelCodes(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static boolean hasCancelCode(String code) {
        for(CancelCodes cancelCodes : values()){
            if( cancelCodes.name.equals(code)){
                return true;
            }
        }

        return false;
    }
}
